/*
 * Decompiled with CFR 0.152.
 */
package furgl.autoPickup;

import furgl.autoPickup.CommandBlacklist;
import furgl.autoPickup.Config;
import furgl.autoPickup.IgnoreKey;
import furgl.autoPickup.PacketIgnoreKey;
import furgl.autoPickup.event.DelayedPickupEvent;
import furgl.autoPickup.event.EntityItemPickupEvents;
import furgl.autoPickup.event.ItemTossEvents;
import furgl.autoPickup.event.PlaySoundAtEntityEvents;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.command.ICommand;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;

@Mod(modid="autopickup", name="AutoPickup", version="2.0", acceptedMinecraftVersions="[1.8]")
public class AutoPickup {
    public static final String MODID = "autopickup";
    public static final String MODNAME = "AutoPickup";
    public static final String VERSION = "2.0";
    public static SimpleNetworkWrapper network;
    public static KeyBinding ignoreBlacklist;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        network = NetworkRegistry.INSTANCE.newSimpleChannel("autoPickupChannel");
        network.registerMessage(PacketIgnoreKey.Handler.class, PacketIgnoreKey.class, 1, Side.SERVER);
        Config.init(event.getSuggestedConfigurationFile());
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        this.registerEventListeners();
        ClientRegistry.registerKeyBinding((KeyBinding)ignoreBlacklist);
    }

    @Mod.EventHandler
    public void serverLoad(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandBlacklist());
    }

    public void registerEventListeners() {
        MinecraftForge.EVENT_BUS.register((Object)new DelayedPickupEvent());
        MinecraftForge.EVENT_BUS.register((Object)new PlaySoundAtEntityEvents());
        MinecraftForge.EVENT_BUS.register((Object)new EntityItemPickupEvents());
        MinecraftForge.EVENT_BUS.register((Object)new ItemTossEvents());
        FMLCommonHandler.instance().bus().register((Object)new IgnoreKey());
        FMLCommonHandler.instance().bus().register((Object)new DelayedPickupEvent());
    }

    public static boolean addItem(EntityPlayer player, ItemStack itemStack, boolean giveIfCreative) {
        if (!giveIfCreative && player.field_71075_bZ.field_75098_d) {
            return true;
        }
        Config.syncFromConfig(player.func_70005_c_());
        if (itemStack != null && (!Config.blacklistNames.contains(itemStack.func_77973_b().func_77653_i(itemStack).replace(" ", "_")) || IgnoreKey.isPressed)) {
            boolean value = player.field_71071_by.func_70441_a(itemStack);
            if (value) {
                player.field_71069_bz.func_75142_b();
            }
            return value;
        }
        return false;
    }

    static {
        ignoreBlacklist = new KeyBinding("Ignore Blacklist", 56, "Auto Pickup");
    }
}

