/*
 * Decompiled with CFR 0.152.
 */
package uk.co.swdteam.halloween.main;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class Graphics {
    public static TextureManager render = Minecraft.func_71410_x().field_71446_o;

    public static int loadTexture(BufferedImage image) {
        int[] pixels = new int[image.getWidth() * image.getHeight()];
        image.getRGB(0, 0, image.getWidth(), image.getHeight(), pixels, 0, image.getWidth());
        ByteBuffer buffer = BufferUtils.createByteBuffer((int)(image.getWidth() * image.getHeight() * 4));
        for (int y = 0; y < image.getHeight(); ++y) {
            for (int x = 0; x < image.getWidth(); ++x) {
                int pixel = pixels[y * image.getWidth() + x];
                buffer.put((byte)(pixel >> 16 & 0xFF));
                buffer.put((byte)(pixel >> 8 & 0xFF));
                buffer.put((byte)(pixel & 0xFF));
                buffer.put((byte)(pixel >> 24 & 0xFF));
            }
        }
        buffer.flip();
        int textureID = GL11.glGenTextures();
        GL11.glBindTexture((int)3553, (int)textureID);
        GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
        GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        GL11.glTexImage2D((int)3553, (int)0, (int)32856, (int)image.getWidth(), (int)image.getHeight(), (int)0, (int)6408, (int)5121, (ByteBuffer)buffer);
        return textureID;
    }

    public static void draw(ResourceLocation r, float h, float y, float f, float g, int depth) {
        GL11.glPushMatrix();
        render.func_110577_a(r);
        Graphics.drawTexture(h, y, f, g, depth);
        GL11.glPopMatrix();
    }

    public static void drawNoBind(float x, float y, float width, float height, int depth) {
        GL11.glPushMatrix();
        Graphics.drawTexture(x, y, width, height, depth);
        GL11.glPopMatrix();
    }

    private static void drawTexture(float x, float y, float width, float height, double zLevel) {
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        Tessellator tessellator = Tessellator.func_178181_a();
        WorldRenderer worldrenderer = tessellator.func_178180_c();
        worldrenderer.func_178970_b();
        worldrenderer.func_178985_a((double)(x + 0.0f), (double)(y + height), zLevel, 0.0, 1.0);
        worldrenderer.func_178985_a((double)(x + width), (double)(y + height), zLevel, 1.0, 1.0);
        worldrenderer.func_178985_a((double)(x + width), (double)(y + 0.0f), zLevel, 1.0, 0.0);
        worldrenderer.func_178985_a((double)(x + 0.0f), (double)(y + 0.0f), zLevel, 0.0, 0.0);
        tessellator.func_78381_a();
        GL11.glDisable((int)3042);
    }

    public static void FillRect(double x, double y, double width, double height, double zLevel, Color col) {
        GL11.glPushMatrix();
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glColor4f((float)((float)col.getRed() / 255.0f), (float)((float)col.getGreen() / 255.0f), (float)((float)col.getBlue() / 255.0f), (float)((float)col.getAlpha() / 255.0f));
        Tessellator tessellator = Tessellator.func_178181_a();
        WorldRenderer worldrenderer = tessellator.func_178180_c();
        worldrenderer.func_178970_b();
        worldrenderer.func_178985_a(x + 0.0, y + height, zLevel, 0.0, 1.0);
        worldrenderer.func_178985_a(x + width, y + height, zLevel, 1.0, 1.0);
        worldrenderer.func_178985_a(x + width, y + 0.0, zLevel, 1.0, 0.0);
        worldrenderer.func_178985_a(x + 0.0, y + 0.0, zLevel, 0.0, 0.0);
        tessellator.func_78381_a();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
    }

    public static void bindTexture(int i) {
        GL11.glBindTexture((int)3553, (int)i);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
    }

    public static void bindTexture(ResourceLocation r) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(r);
    }
}

