/*
 * Decompiled with CFR 0.152.
 */
package uk.co.swdteam.halloween.client.render;

import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.Color;
import uk.co.swdteam.halloween.client.model.ModelCube;
import uk.co.swdteam.halloween.server.tileEntity.TileEntityPumpkin;

public class RenderPumpkin
extends TileEntitySpecialRenderer {
    public ResourceLocation texture = new ResourceLocation("carvablepumpkins:textures/models/pumpkin.png");
    public ResourceLocation whiteTexture = new ResourceLocation("carvablepumpkins:textures/models/white.png");
    public ModelCube cube;
    public Color mid = new Color(67, 18, 1);
    public Color dark = new Color(46, 1, 4);

    public RenderPumpkin() {
        this.cube = new ModelCube();
    }

    public void func_180535_a(TileEntity tileentity, double d, double d1, double d2, float p_180535_8_, int p_180535_9_) {
        TileEntityPumpkin tileentity1 = null;
        if (tileentity instanceof TileEntityPumpkin) {
            tileentity1 = (TileEntityPumpkin)tileentity;
        }
        if (tileentity1 == null) {
            return;
        }
        int metadata = tileentity1.func_145832_p();
        int rotationAngle = 0;
        if (metadata % 4 == 3) {
            rotationAngle = 0;
        }
        if (metadata % 4 == 1) {
            rotationAngle = 270;
        }
        if (metadata % 4 == 2) {
            rotationAngle = 180;
        }
        if (metadata % 4 == 0) {
            rotationAngle = 90;
        }
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)d + 1.5f), (float)((float)d1 + 1.5f), (float)((float)d2 - 0.5f));
        GL11.glScalef((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glTranslatef((float)-1.0f, (float)0.0f, (float)-1.0f);
        GL11.glRotatef((float)rotationAngle, (float)0.0f, (float)1.0f, (float)0.0f);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(this.texture);
        GL11.glPushMatrix();
        this.cube.render(0.0625f);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)2.0f, (float)0.0f);
        Tessellator t2 = Tessellator.func_178181_a();
        WorldRenderer t = t2.func_178180_c();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(this.whiteTexture);
        GL11.glScalef((float)1.001f, (float)1.001f, (float)1.001f);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)-1.0f, (float)-1.0f, (float)0.0f);
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        t.func_178970_b();
        this.drawFace(tileentity1.getSide_1(), t, tileentity1.isLight());
        t2.func_78381_a();
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)-1.0f, (float)-1.0f);
        GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        t.func_178970_b();
        this.drawFace(tileentity1.getSide_2(), t, tileentity1.isLight());
        t2.func_78381_a();
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)1.0f, (float)-1.0f, (float)0.0f);
        GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        t.func_178970_b();
        this.drawFace(tileentity1.getSide_3(), t, tileentity1.isLight());
        t2.func_78381_a();
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)-1.0f, (float)1.0f);
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        t.func_178970_b();
        this.drawFace(tileentity1.getSide_4(), t, tileentity1.isLight());
        t2.func_78381_a();
        GL11.glPopMatrix();
        GL11.glPopMatrix();
        GL11.glPopMatrix();
        GL11.glPopMatrix();
    }

    public void drawFace(int[][] sideT, WorldRenderer t, boolean light) {
        Color col = this.mid;
        if (light) {
            Random rand = Minecraft.func_71410_x().field_71441_e.field_73012_v;
            switch (rand.nextInt(2)) {
                case 0: {
                    col = new Color(216, 232, 70);
                    break;
                }
                case 1: {
                    col = new Color(238, 244, 54);
                    break;
                }
                default: {
                    col = new Color(224, 222, 54);
                }
            }
            this.dark = new Color(95, 0, 2);
        } else {
            this.mid = new Color(67, 18, 1);
            this.dark = new Color(46, 1, 4);
        }
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                int[][] side = sideT;
                if (side[i][j] != 1) continue;
                if (i < 15 && i > 0 && j < 15 && j > 0) {
                    if (side[i + 1][j] == 1 && side[i - 1][j] == 0 || side[i][j + 1] == 1 && side[i][j - 1] == 0) {
                        this.drawPixel(j, i, this.dark, t);
                    } else {
                        this.drawPixel(j, i, col, t);
                    }
                }
                if (i == 0) {
                    if (side[i + 1][j] == 1) {
                        this.drawPixel(j, i, this.dark, t);
                    } else {
                        this.drawPixel(j, i, col, t);
                    }
                }
                if (i == 15 && j > 0 && j < 15) {
                    if (side[i][j - 1] == 0) {
                        this.drawPixel(j, i, this.dark, t);
                    } else {
                        this.drawPixel(j, i, col, t);
                    }
                }
                if (j == 0) {
                    if (side[i][j + 1] == 1) {
                        this.drawPixel(j, i, this.dark, t);
                    } else {
                        this.drawPixel(j, i, col, t);
                    }
                }
                if (j != 15) continue;
                if (i > 0 && i < 15) {
                    if (side[i - 1][j] == 0) {
                        this.drawPixel(j, i, this.dark, t);
                        continue;
                    }
                    this.drawPixel(j, i, col, t);
                    continue;
                }
                if (i == 0) {
                    if (side[i + 1][j] == 1) {
                        this.drawPixel(j, i, this.dark, t);
                    } else {
                        this.drawPixel(j, i, col, t);
                    }
                }
                if (i != 15) continue;
                this.drawPixel(j, i, col, t);
            }
        }
    }

    public void drawPixel(float x, float y, Color c, WorldRenderer t) {
        t.func_178961_b(c.getRed(), c.getGreen(), c.getBlue(), c.getAlpha());
        t.func_178985_a(0.5, 0.498 + (double)y / 15.95, 0.435 - (double)x / 15.95, 0.0, 0.0);
        t.func_178985_a(0.5, 0.561 + (double)y / 15.95, 0.435 - (double)x / 15.95, 0.0, 1.0);
        t.func_178985_a(0.5, 0.561 + (double)y / 15.95, 0.499 - (double)x / 15.95, 1.0, 1.0);
        t.func_178985_a(0.5, 0.498 + (double)y / 15.95, 0.499 - (double)x / 15.95, 1.0, 0.0);
    }
}

