/*
 * Decompiled with CFR 0.152.
 */
package uk.co.swdteam.halloween.server.block;

import com.google.common.base.Predicate;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import uk.co.swdteam.halloween.main.Data;
import uk.co.swdteam.halloween.main.PumpkinMod;
import uk.co.swdteam.halloween.server.tileEntity.TileEntityPumpkin;

public class BlockPumpkin
extends BlockContainer {
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);

    public BlockPumpkin() {
        super(Material.field_151575_d);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        float f = 0.0f;
        this.func_149711_c(1.4f);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (playerIn.func_71045_bC() != null && playerIn.func_71045_bC().func_77973_b() == PumpkinMod.pumpkinCarvingKnife) {
            if (side == EnumFacing.UP || side == EnumFacing.DOWN) {
                return false;
            }
            TileEntityPumpkin tep = (TileEntityPumpkin)worldIn.func_175625_s(pos);
            if (tep != null) {
                int x = MathHelper.func_76141_d((float)((side == EnumFacing.SOUTH || side == EnumFacing.NORTH ? hitX : hitZ) * 16.0f));
                if (side == EnumFacing.NORTH || side == EnumFacing.EAST) {
                    x = 15 - x;
                }
                int y = MathHelper.func_76141_d((float)(hitY * 16.0f));
                y = 15 - y;
                if (x > 15) {
                    x = 0;
                }
                if (y > 15) {
                    y = 0;
                }
                Comparable blockFacing = worldIn.func_180495_p(pos).func_177229_b((IProperty)FACING);
                switch (side) {
                    case NORTH: {
                        if (blockFacing == EnumFacing.SOUTH) {
                            tep.getSide_3()[x][y] = 1;
                        }
                        if (blockFacing == EnumFacing.EAST) {
                            tep.getSide_2()[x][y] = 1;
                        }
                        if (blockFacing == EnumFacing.WEST) {
                            tep.getSide_4()[x][y] = 1;
                        }
                        if (blockFacing != EnumFacing.NORTH) break;
                        tep.getSide_1()[x][y] = 1;
                        break;
                    }
                    case WEST: {
                        if (blockFacing == EnumFacing.SOUTH) {
                            tep.getSide_4()[x][y] = 1;
                        }
                        if (blockFacing == EnumFacing.EAST) {
                            tep.getSide_3()[x][y] = 1;
                        }
                        if (blockFacing == EnumFacing.WEST) {
                            tep.getSide_1()[x][y] = 1;
                        }
                        if (blockFacing != EnumFacing.NORTH) break;
                        tep.getSide_2()[x][y] = 1;
                        break;
                    }
                    case SOUTH: {
                        if (blockFacing == EnumFacing.SOUTH) {
                            tep.getSide_1()[x][y] = 1;
                        }
                        if (blockFacing == EnumFacing.EAST) {
                            tep.getSide_4()[x][y] = 1;
                        }
                        if (blockFacing == EnumFacing.WEST) {
                            tep.getSide_2()[x][y] = 1;
                        }
                        if (blockFacing != EnumFacing.NORTH) break;
                        tep.getSide_3()[x][y] = 1;
                        break;
                    }
                    case EAST: {
                        if (blockFacing == EnumFacing.SOUTH) {
                            tep.getSide_2()[x][y] = 1;
                        }
                        if (blockFacing == EnumFacing.EAST) {
                            tep.getSide_1()[x][y] = 1;
                        }
                        if (blockFacing == EnumFacing.WEST) {
                            tep.getSide_3()[x][y] = 1;
                        }
                        if (blockFacing != EnumFacing.NORTH) break;
                        tep.getSide_4()[x][y] = 1;
                        break;
                    }
                }
                worldIn.func_72980_b((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), "step.wood", 1.0f, 0.75f, false);
                for (int i = 0; i < 10; ++i) {
                    worldIn.func_175682_a(EnumParticleTypes.BLOCK_CRACK, true, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 0.0, 0.0, 0.0, new int[]{Block.func_149682_b((Block)this)});
                }
                if (!worldIn.field_72995_K && tep.seedsDroppd < 6 && MathHelper.func_76136_a((Random)worldIn.field_73012_v, (int)0, (int)50) == 25) {
                    worldIn.func_72838_d((Entity)new EntityItem(worldIn, (double)((float)pos.func_177958_n() + hitX), (double)((float)pos.func_177956_o() + hitY), (double)((float)pos.func_177952_p() + hitZ), new ItemStack(Items.field_151080_bb)));
                    ++tep.seedsDroppd;
                }
            }
            return false;
        }
        if (worldIn.func_175625_s(pos) != null) {
            playerIn.openGui((Object)PumpkinMod.instance, 0, worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityPumpkin();
    }

    public int idDropped(int i, Random random, int j) {
        return 0;
    }

    public int quanityDropped(Random random) {
        return 1;
    }

    public int func_149645_b() {
        return -1;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        worldIn.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d()), 2);
    }

    public TileEntity func_149915_a(World world, int i) {
        return new TileEntityPumpkin();
    }

    @SideOnly(value=Side.CLIENT)
    public IBlockState func_176217_b(IBlockState state) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.SOUTH);
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_82600_a((int)meta);
        if (enumfacing.func_176740_k() == EnumFacing.Axis.Y) {
            enumfacing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    protected BlockState func_180661_e() {
        return new BlockState((Block)this, new IProperty[]{FACING});
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, BlockPos p) {
        ItemStack s = new ItemStack(PumpkinMod.pumpkinItem);
        s.func_77982_d(new NBTTagCompound());
        TileEntity t = world.func_175625_s(p);
        if (t instanceof TileEntityPumpkin) {
            TileEntityPumpkin t1 = (TileEntityPumpkin)world.func_175625_s(p);
            s.func_77978_p().func_74783_a("side_1", Data.to1dArray(t1.getSide_1()));
            s.func_77978_p().func_74783_a("side_2", Data.to1dArray(t1.getSide_2()));
            s.func_77978_p().func_74783_a("side_3", Data.to1dArray(t1.getSide_3()));
            s.func_77978_p().func_74783_a("side_4", Data.to1dArray(t1.getSide_4()));
            s.func_77978_p().func_74757_a("isLit", t1.isLight());
            s.func_77978_p().func_74768_a("seedDropCount", t1.getSeedsDroppd());
        }
        return s;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
    }

    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        if (!player.field_71075_bZ.field_75098_d) {
            worldIn.func_72838_d((Entity)new EntityItem(worldIn, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, this.getPickBlock(null, worldIn, pos)));
        }
    }

    public void func_176206_d(World worldIn, BlockPos pos, IBlockState state) {
        super.func_176206_d(worldIn, pos, state);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return null;
    }
}

