/*
 * Decompiled with CFR 0.152.
 */
package me.heldplayer.mods.aurora.client;

import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import me.heldplayer.mods.aurora.CommonProxy;
import me.heldplayer.mods.aurora.client.render.OverworldSkyRenderer;
import me.heldplayer.mods.aurora.client.render.SkyRendererAurora;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Timer;
import net.minecraft.world.World;
import net.minecraftforge.client.IRenderHandler;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.specialattack.forge.core.client.shader.ShaderCallback;
import net.specialattack.forge.core.client.shader.ShaderManager;
import net.specialattack.forge.core.client.shader.ShaderProgram;
import net.specialattack.forge.core.client.shader.ShaderUniform;

@SideOnly(value=Side.CLIENT)
public class ClientProxy
extends CommonProxy {
    public static ShaderManager.ShaderBinding auroraShader;

    public void preInit(FMLPreInitializationEvent event) {
        super.preInit(event);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void postInit(FMLPostInitializationEvent event) {
        super.postInit(event);
        auroraShader = ShaderManager.getShader((ResourceLocation)new ResourceLocation("colormysky:shaders/aurora"));
        if (auroraShader != null && auroraShader.getShader() != null) {
            ShaderProgram shader = auroraShader.getShader();
            shader.addCallback(new ShaderCallback(){
                private float time;
                private float prevPartial;

                public void call(ShaderProgram program) {
                    ShaderUniform vertexSize;
                    ShaderUniform time = program.getUniform("time");
                    if (time != null) {
                        Timer timer = net.specialattack.forge.core.client.ClientProxy.getMinecraftTimer();
                        float partial = timer.field_74281_c;
                        this.time = partial < this.prevPartial ? (this.time += 1.0f - this.prevPartial + partial) : (this.time += partial - this.prevPartial);
                        this.prevPartial = partial;
                        time.set1(this.time / 300.0f);
                    }
                    if ((vertexSize = program.getUniform("vertexSize")) != null) {
                        vertexSize.set1(600.0f);
                    }
                }
            });
        }
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        World world = event.world;
        if (world instanceof WorldClient && world.field_73011_w.field_76574_g == 0) {
            IRenderHandler oldRenderer = world.field_73011_w.getSkyRenderer();
            if (oldRenderer != null) {
                world.field_73011_w.setSkyRenderer((IRenderHandler)new SkyRendererAurora(oldRenderer));
            } else {
                world.field_73011_w.setSkyRenderer((IRenderHandler)new OverworldSkyRenderer());
            }
        }
    }
}

