/*
 * Decompiled with CFR 0.152.
 */
package me.heldplayer.mods.aurora.client.render;

import cpw.mods.fml.relauncher.ReflectionHelper;
import java.lang.reflect.Method;
import java.util.Random;
import me.heldplayer.mods.aurora.client.ClientProxy;
import me.heldplayer.mods.aurora.client.render.SphereRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.Entity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraftforge.client.IRenderHandler;
import net.specialattack.forge.core.client.GLState;
import net.specialattack.forge.core.client.MC;
import net.specialattack.forge.core.client.shader.ShaderProgram;
import org.lwjgl.opengl.GL11;

public class OverworldSkyRenderer
extends IRenderHandler {
    private static final ResourceLocation locationMoonPhasesPng = new ResourceLocation("textures/environment/moon_phases.png");
    private static final ResourceLocation locationSunPng = new ResourceLocation("textures/environment/sun.png");
    private int starGLCallList;
    private int glSkyList;
    private int glSkyList2;
    private SphereRenderer sky = new SphereRenderer(200.0f, 3);
    private static Method getFOVModifier = ReflectionHelper.findMethod(EntityRenderer.class, (Object)MC.getEntityRenderer(), (String[])new String[]{"getFOVModifier", "func_78481_a"}, (Class[])new Class[]{Float.TYPE, Boolean.TYPE});

    public OverworldSkyRenderer() {
        int k;
        int j;
        this.starGLCallList = GLAllocation.func_74526_a((int)3);
        GLState.glPushMatrix();
        GL11.glNewList((int)this.starGLCallList, (int)4864);
        this.renderStars();
        GL11.glEndList();
        GLState.glPopMatrix();
        Tessellator tessellator = Tessellator.field_78398_a;
        this.glSkyList = this.starGLCallList + 1;
        GL11.glNewList((int)this.glSkyList, (int)4864);
        int b2 = 64;
        int i = 256 / b2 + 2;
        float f = 16.0f;
        for (j = -b2 * i; j <= b2 * i; j += b2) {
            for (k = -b2 * i; k <= b2 * i; k += b2) {
                tessellator.func_78382_b();
                tessellator.func_78377_a((double)j, (double)f, (double)k);
                tessellator.func_78377_a((double)(j + b2), (double)f, (double)k);
                tessellator.func_78377_a((double)(j + b2), (double)f, (double)(k + b2));
                tessellator.func_78377_a((double)j, (double)f, (double)(k + b2));
                tessellator.func_78381_a();
            }
        }
        GL11.glEndList();
        this.glSkyList2 = this.starGLCallList + 2;
        GL11.glNewList((int)this.glSkyList2, (int)4864);
        f = -16.0f;
        tessellator.func_78382_b();
        for (j = -b2 * i; j <= b2 * i; j += b2) {
            for (k = -b2 * i; k <= b2 * i; k += b2) {
                tessellator.func_78377_a((double)(j + b2), (double)f, (double)k);
                tessellator.func_78377_a((double)j, (double)f, (double)k);
                tessellator.func_78377_a((double)j, (double)f, (double)(k + b2));
                tessellator.func_78377_a((double)(j + b2), (double)f, (double)(k + b2));
            }
        }
        tessellator.func_78381_a();
        GL11.glEndList();
    }

    private void renderStars() {
        Random random = new Random(10842L);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        for (int i = 0; i < 1500; ++i) {
            double d0 = random.nextFloat() * 2.0f - 1.0f;
            double d1 = random.nextFloat() * 2.0f - 1.0f;
            double d2 = random.nextFloat() * 2.0f - 1.0f;
            double d3 = 0.15f + random.nextFloat() * 0.1f;
            double d4 = d0 * d0 + d1 * d1 + d2 * d2;
            if (!(d4 < 1.0) || !(d4 > 0.01)) continue;
            d4 = 1.0 / Math.sqrt(d4);
            double d5 = (d0 *= d4) * 100.0;
            double d6 = (d1 *= d4) * 100.0;
            double d7 = (d2 *= d4) * 100.0;
            double d8 = Math.atan2(d0, d2);
            double d9 = Math.sin(d8);
            double d10 = Math.cos(d8);
            double d11 = Math.atan2(Math.sqrt(d0 * d0 + d2 * d2), d1);
            double d12 = Math.sin(d11);
            double d13 = Math.cos(d11);
            double d14 = random.nextDouble() * Math.PI * 2.0;
            double d15 = Math.sin(d14);
            double d16 = Math.cos(d14);
            for (int j = 0; j < 4; ++j) {
                double d17 = 0.0;
                double d18 = (double)((j & 2) - 1) * d3;
                double d19 = (double)((j + 1 & 2) - 1) * d3;
                double d20 = d18 * d16 - d19 * d15;
                double d21 = d19 * d16 + d18 * d15;
                double d22 = d20 * d12 + d17 * d13;
                double d23 = d17 * d12 - d20 * d13;
                double d24 = d23 * d9 - d21 * d10;
                double d25 = d21 * d9 + d23 * d10;
                tessellator.func_78377_a(d5 + d24, d6 + d22, d7 + d25);
            }
        }
        tessellator.func_78381_a();
    }

    public void render(float partialTicks, WorldClient world, Minecraft mc) {
        this.renderDefaultSky(partialTicks, world, mc);
        this.renderAurora(partialTicks, world, mc);
    }

    private void renderAurora(float partialTicks, WorldClient world, Minecraft mc) {
        boolean hasShader = ClientProxy.auroraShader != null && ClientProxy.auroraShader.getShader() != null;
        float starBrightness = world.func_72880_h(partialTicks) * (1.0f - world.func_72867_j(partialTicks)) - 0.1f;
        if (hasShader && starBrightness > 0.0f) {
            ShaderProgram shader = ClientProxy.auroraShader.getShader();
            shader.bind();
            shader.getUniform("brightness").set1(starBrightness * 2.5f);
            float horizon = (float)mc.field_71439_g.func_70666_h((float)partialTicks).field_72448_b;
            GLState.glDisable((int)3553);
            GLState.glDisable((int)2884);
            GLState.glDisable((int)2912);
            GLState.glDisable((int)3008);
            GLState.glEnable((int)3042);
            GLState.glDepthMask((boolean)false);
            GLState.glPushMatrix();
            GLState.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.sky.render();
            GLState.glPopMatrix();
            GLState.glDepthMask((boolean)true);
            GLState.glDisable((int)3042);
            GLState.glEnable((int)3008);
            GLState.glEnable((int)2912);
            GLState.glEnable((int)2884);
            GLState.glEnable((int)3553);
            shader.unbind();
        }
    }

    private void renderDefaultSky(float partialTicks, WorldClient world, Minecraft mc) {
        float f10;
        float f9;
        float f8;
        float f7;
        float f6;
        GLState.glDisable((int)3553);
        Vec3 vec3 = world.func_72833_a((Entity)mc.field_71451_h, partialTicks);
        float f1 = (float)vec3.field_72450_a;
        float f2 = (float)vec3.field_72448_b;
        float f3 = (float)vec3.field_72449_c;
        if (mc.field_71474_y.field_74337_g) {
            float f4 = (f1 * 30.0f + f2 * 59.0f + f3 * 11.0f) / 100.0f;
            float f5 = (f1 * 30.0f + f2 * 70.0f) / 100.0f;
            f6 = (f1 * 30.0f + f3 * 70.0f) / 100.0f;
            f1 = f4;
            f2 = f5;
            f3 = f6;
        }
        GLState.glColor3f((float)f1, (float)f2, (float)f3);
        Tessellator tessellator1 = Tessellator.field_78398_a;
        GLState.glDepthMask((boolean)false);
        GLState.glEnable((int)2912);
        GLState.glColor3f((float)f1, (float)f2, (float)f3);
        GL11.glCallList((int)this.glSkyList);
        GLState.glDisable((int)2912);
        GLState.glDisable((int)3008);
        GLState.glEnable((int)3042);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        RenderHelper.func_74518_a();
        float[] afloat = world.field_73011_w.func_76560_a(world.func_72826_c(partialTicks), partialTicks);
        if (afloat != null) {
            float f11;
            GLState.glDisable((int)3553);
            GLState.glShadeModel((int)7425);
            GLState.glPushMatrix();
            GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)(MathHelper.func_76126_a((float)world.func_72929_e(partialTicks)) < 0.0f ? 180.0f : 0.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            f6 = afloat[0];
            f7 = afloat[1];
            f8 = afloat[2];
            if (mc.field_71474_y.field_74337_g) {
                f9 = (f6 * 30.0f + f7 * 59.0f + f8 * 11.0f) / 100.0f;
                f10 = (f6 * 30.0f + f7 * 70.0f) / 100.0f;
                f11 = (f6 * 30.0f + f8 * 70.0f) / 100.0f;
                f6 = f9;
                f7 = f10;
                f8 = f11;
            }
            tessellator1.func_78371_b(6);
            tessellator1.func_78369_a(f6, f7, f8, afloat[3]);
            tessellator1.func_78377_a(0.0, 100.0, 0.0);
            int b0 = 16;
            tessellator1.func_78369_a(afloat[0], afloat[1], afloat[2], 0.0f);
            for (int j = 0; j <= b0; ++j) {
                f11 = (float)j * (float)Math.PI * 2.0f / (float)b0;
                float f12 = MathHelper.func_76126_a((float)f11);
                float f13 = MathHelper.func_76134_b((float)f11);
                tessellator1.func_78377_a((double)(f12 * 120.0f), (double)(f13 * 120.0f), (double)(-f13 * 40.0f * afloat[3]));
            }
            tessellator1.func_78381_a();
            GLState.glPopMatrix();
            GLState.glShadeModel((int)7424);
        }
        GLState.glEnable((int)3553);
        OpenGlHelper.func_148821_a((int)770, (int)1, (int)1, (int)0);
        GLState.glPushMatrix();
        f6 = 1.0f - world.func_72867_j(partialTicks);
        f7 = 0.0f;
        f8 = 0.0f;
        f9 = 0.0f;
        GLState.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)f6);
        GL11.glTranslatef((float)f7, (float)f8, (float)f9);
        GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(world.func_72826_c(partialTicks) * 360.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        f10 = 30.0f;
        MC.getTextureManager().func_110577_a(locationSunPng);
        tessellator1.func_78382_b();
        tessellator1.func_78374_a((double)(-f10), 100.0, (double)(-f10), 0.0, 0.0);
        tessellator1.func_78374_a((double)f10, 100.0, (double)(-f10), 1.0, 0.0);
        tessellator1.func_78374_a((double)f10, 100.0, (double)f10, 1.0, 1.0);
        tessellator1.func_78374_a((double)(-f10), 100.0, (double)f10, 0.0, 1.0);
        tessellator1.func_78381_a();
        f10 = 20.0f;
        MC.getTextureManager().func_110577_a(locationMoonPhasesPng);
        int k = world.func_72853_d();
        int l = k % 4;
        int i1 = k / 4 % 2;
        float f14 = (float)l / 4.0f;
        float f15 = (float)i1 / 2.0f;
        float f16 = (float)(l + 1) / 4.0f;
        float f17 = (float)(i1 + 1) / 2.0f;
        tessellator1.func_78382_b();
        tessellator1.func_78374_a((double)(-f10), -100.0, (double)f10, (double)f16, (double)f17);
        tessellator1.func_78374_a((double)f10, -100.0, (double)f10, (double)f14, (double)f17);
        tessellator1.func_78374_a((double)f10, -100.0, (double)(-f10), (double)f14, (double)f15);
        tessellator1.func_78374_a((double)(-f10), -100.0, (double)(-f10), (double)f16, (double)f15);
        tessellator1.func_78381_a();
        GLState.glDisable((int)3553);
        float f18 = world.func_72880_h(partialTicks) * f6;
        if (f18 > 0.0f) {
            GLState.glColor4f((float)f18, (float)f18, (float)f18, (float)f18);
            GL11.glCallList((int)this.starGLCallList);
        }
        GLState.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GLState.glDisable((int)3042);
        GLState.glEnable((int)3008);
        GLState.glEnable((int)2912);
        GLState.glPopMatrix();
        GLState.glDisable((int)3553);
        GLState.glColor3f((float)0.0f, (float)0.0f, (float)0.0f);
        double d0 = mc.field_71439_g.func_70666_h((float)partialTicks).field_72448_b - world.func_72919_O();
        if (d0 < 0.0) {
            GLState.glPushMatrix();
            GL11.glTranslatef((float)0.0f, (float)12.0f, (float)0.0f);
            GL11.glCallList((int)this.glSkyList2);
            GLState.glPopMatrix();
            f8 = 1.0f;
            f9 = -((float)(d0 + 65.0));
            f10 = -f8;
            tessellator1.func_78382_b();
            tessellator1.func_78384_a(0, 255);
            tessellator1.func_78377_a((double)(-f8), (double)f9, (double)f8);
            tessellator1.func_78377_a((double)f8, (double)f9, (double)f8);
            tessellator1.func_78377_a((double)f8, (double)f10, (double)f8);
            tessellator1.func_78377_a((double)(-f8), (double)f10, (double)f8);
            tessellator1.func_78377_a((double)(-f8), (double)f10, (double)(-f8));
            tessellator1.func_78377_a((double)f8, (double)f10, (double)(-f8));
            tessellator1.func_78377_a((double)f8, (double)f9, (double)(-f8));
            tessellator1.func_78377_a((double)(-f8), (double)f9, (double)(-f8));
            tessellator1.func_78377_a((double)f8, (double)f10, (double)(-f8));
            tessellator1.func_78377_a((double)f8, (double)f10, (double)f8);
            tessellator1.func_78377_a((double)f8, (double)f9, (double)f8);
            tessellator1.func_78377_a((double)f8, (double)f9, (double)(-f8));
            tessellator1.func_78377_a((double)(-f8), (double)f9, (double)(-f8));
            tessellator1.func_78377_a((double)(-f8), (double)f9, (double)f8);
            tessellator1.func_78377_a((double)(-f8), (double)f10, (double)f8);
            tessellator1.func_78377_a((double)(-f8), (double)f10, (double)(-f8));
            tessellator1.func_78377_a((double)(-f8), (double)f10, (double)(-f8));
            tessellator1.func_78377_a((double)(-f8), (double)f10, (double)f8);
            tessellator1.func_78377_a((double)f8, (double)f10, (double)f8);
            tessellator1.func_78377_a((double)f8, (double)f10, (double)(-f8));
            tessellator1.func_78381_a();
        }
        if (world.field_73011_w.func_76561_g()) {
            GLState.glColor3f((float)(f1 * 0.2f + 0.04f), (float)(f2 * 0.2f + 0.04f), (float)(f3 * 0.6f + 0.1f));
        } else {
            GLState.glColor3f((float)f1, (float)f2, (float)f3);
        }
        GLState.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)(-((float)(d0 - 16.0))), (float)0.0f);
        GL11.glCallList((int)this.glSkyList2);
        GLState.glPopMatrix();
        GLState.glEnable((int)3553);
        GLState.glDepthMask((boolean)true);
    }
}

