/*
 * Decompiled with CFR 0.152.
 */
package me.heldplayer.mods.aurora.client.render;

import me.heldplayer.mods.aurora.client.ClientProxy;
import me.heldplayer.mods.aurora.client.render.SphereRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraftforge.client.IRenderHandler;
import net.specialattack.forge.core.client.GLState;
import net.specialattack.forge.core.client.shader.ShaderProgram;

public class SkyRendererAurora
extends IRenderHandler {
    private IRenderHandler parent;
    private SphereRenderer sky = new SphereRenderer(200.0f, 3);

    public SkyRendererAurora(IRenderHandler parent) {
        this.parent = parent;
    }

    public void render(float partialTicks, WorldClient world, Minecraft mc) {
        this.parent.render(partialTicks, world, mc);
        this.renderAurora(partialTicks, world, mc);
    }

    private void renderAurora(float partialTicks, WorldClient world, Minecraft mc) {
        boolean hasShader = ClientProxy.auroraShader != null && ClientProxy.auroraShader.getShader() != null;
        float starBrightness = world.func_72880_h(partialTicks) * (1.0f - world.func_72867_j(partialTicks)) - 0.1f;
        if (hasShader && starBrightness > 0.0f) {
            ShaderProgram shader = ClientProxy.auroraShader.getShader();
            shader.bind();
            shader.getUniform("brightness").set1(starBrightness * 2.5f);
            float horizon = (float)mc.field_71439_g.func_70666_h((float)partialTicks).field_72448_b;
            GLState.glDisable((int)3553);
            GLState.glDisable((int)2884);
            GLState.glDisable((int)2912);
            GLState.glDisable((int)3008);
            GLState.glEnable((int)3042);
            GLState.glDepthMask((boolean)false);
            GLState.glPushMatrix();
            GLState.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.sky.render();
            GLState.glPopMatrix();
            GLState.glDepthMask((boolean)true);
            GLState.glDisable((int)3042);
            GLState.glEnable((int)3008);
            GLState.glEnable((int)2912);
            GLState.glEnable((int)2884);
            GLState.glEnable((int)3553);
            shader.unbind();
        }
    }
}

