/*
 * Decompiled with CFR 0.152.
 */
package cad97.spawnercraft.handler;

import cad97.spawnercraft.utility.LogHelper;
import java.io.File;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ConfigHandler {
    public static final ConfigHandler instance = new ConfigHandler();
    public static Configuration config;
    public static int spawnerDropSilkLevel;
    public static boolean spawnerCraftable;
    public static boolean dropsRequireFishing;

    private ConfigHandler() {
    }

    public static void init(File configFile) {
        if (config == null) {
            config = new Configuration(configFile);
        }
        ConfigHandler.loadConfig();
        LogHelper.logInfo("ConfigHandler initialized.");
    }

    @SubscribeEvent
    public void onConfigurationChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equalsIgnoreCase("spawnercraft")) {
            ConfigHandler.loadConfig();
        }
    }

    private static void loadConfig() {
        spawnerDropSilkLevel = config.get("general", "Silk Touch for Spawner Drop", 0, "Required silk touch level to drop Empty Spawners from normal Mob Spawners.\nSet higher than obtainable silk touch (vanilla: >1) to disable.").getInt(0);
        spawnerCraftable = config.get("general", "Is Empty Spawner Craftable", false, "Is it possible to craft an Empty Monster Spawner from iron bars?").setRequiresMcRestart(true).getBoolean();
        dropsRequireFishing = config.get("general", "Essence Drops Require Fishing", true, "Do Mob Essence drops require the use of a Mob Fishing Pole?").getBoolean();
        if (config.hasChanged()) {
            config.save();
        }
    }
}

