/*
 * Decompiled with CFR 0.152.
 */
package rafradek.spin;

import com.google.common.base.Predicate;
import com.mojang.authlib.GameProfile;
import java.util.Arrays;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityOtherPlayerMP;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelPlayer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;
import rafradek.spin.EnchantmentSpin;

@Mod(modid="rafradek_spin", name="Spin To Win", version="1.2", guiFactory="rafradek.spin.SpinGuiFactory", acceptedMinecraftVersions="[1.11.2]")
public class SpinToWin {
    public static DataParameter<Boolean> SPIN_TIME;
    public static Enchantment ench;
    public static UUID SPIN_AS;
    public static UUID SPIN_AD;
    private static final ResourceLocation SPIN_TEXTURE;
    public static Configuration conf;
    public static int spinID;
    public static double range;
    public static float swordDmg;
    public static float axeDmg;
    public static float speed;
    public static int cooldownAxe;
    public static int cooldownSword;
    public static int duration;
    public static ResourceLocation[] blacklistItems;
    public static ResourceLocation[] swordItems;
    public static ResourceLocation[] toolItems;
    public static EntityPlayer fakePlayer;

    @Mod.EventHandler
    public void init(FMLPreInitializationEvent event) {
        conf = new Configuration(event.getSuggestedConfigurationFile());
        this.syncConfig();
        SPIN_TIME = new DataParameter(spinID, DataSerializers.field_187198_h);
        ench = (Enchantment)GameRegistry.register((IForgeRegistryEntry)new EnchantmentSpin().setRegistryName("rafradek_spin", "spin"));
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void syncConfig() {
        int i;
        spinID = conf.getInt("Spin data parameter ID", "config", 173, 32, 255, "Change this if you encounter problems with duplicated data parameter id");
        range = conf.getFloat("Spin range", "config", 3.7f, 0.0f, 1000.0f, "Ability's range");
        swordDmg = conf.getFloat("Sword damage multiplier", "config", 0.7f, 0.0f, 1000.0f, "");
        axeDmg = conf.getFloat("Axe damage multiplier", "config", 1.15f, 0.0f, 1000.0f, "");
        speed = 1.0f / conf.getFloat("Spin speed multiplier", "config", 1.0f, 0.0f, 100.0f, "");
        cooldownAxe = conf.getInt("Axe spin cooldown", "config", 220, 0, 1000, "");
        cooldownSword = conf.getInt("Sword spin cooldown", "config", 280, 0, 1000, "");
        duration = conf.getInt("Sword spin duration", "config", 90, 0, 1000, "");
        conf.get("config", "Spin data parameter ID", 173).setRequiresMcRestart(true);
        String[] listbl = conf.getStringList("Blacklist items", "config", new String[0], "Registry names of items which should not be spinnable");
        String[] listsw = conf.getStringList("Swords", "config", new String[0], "Registry names of items that spin multiple times");
        String[] listtl = conf.getStringList("Axes/tools", "config", new String[0], "Registry names of items that spin once");
        blacklistItems = new ResourceLocation[listbl.length];
        for (i = 0; i < blacklistItems.length; ++i) {
            SpinToWin.blacklistItems[i] = new ResourceLocation(listbl[i]);
        }
        swordItems = new ResourceLocation[listsw.length];
        for (i = 0; i < swordItems.length; ++i) {
            SpinToWin.swordItems[i] = new ResourceLocation(listsw[i]);
        }
        toolItems = new ResourceLocation[listtl.length];
        for (i = 0; i < toolItems.length; ++i) {
            SpinToWin.toolItems[i] = new ResourceLocation(listtl[i]);
        }
        if (conf.hasChanged()) {
            conf.save();
        }
    }

    public boolean isValid(Item stack) {
        for (ResourceLocation location : blacklistItems) {
            if (!location.equals((Object)stack.getRegistryName())) continue;
            return false;
        }
        return this.isSword(stack) || this.isTool(stack);
    }

    public boolean isSword(Item stack) {
        for (ResourceLocation location : swordItems) {
            if (!location.equals((Object)stack.getRegistryName())) continue;
            return true;
        }
        return stack instanceof ItemSword;
    }

    public boolean isTool(Item stack) {
        for (ResourceLocation location : toolItems) {
            if (!location.equals((Object)stack.getRegistryName())) continue;
            return true;
        }
        return stack instanceof ItemTool;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addToBlacklist(ItemStack stack) {
        if (stack.func_77957_a((World)Minecraft.func_71410_x().field_71441_e, (EntityPlayer)new EntityOtherPlayerMP((World)Minecraft.func_71410_x().field_71441_e, new GameProfile(null, "fake")), EnumHand.MAIN_HAND).func_188397_a() != EnumActionResult.PASS) {
            Property blackList = conf.get("config", "Blacklist items", new String[0]);
            blackList.set(Arrays.copyOf(blackList.getStringList(), blackList.getStringList().length + 1));
            blackList.getStringList()[blackList.getStringList().length - 1] = stack.func_77973_b().getRegistryName().toString();
            this.syncConfig();
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public void stopUsing(PlayerInteractEvent.RightClickItem event) {
        ItemStack stack = event.getEntityPlayer().func_184614_ca();
        if (!stack.func_190926_b() && this.isValid(stack.func_77973_b())) {
            event.getEntityPlayer().getEntityData().func_74768_a("SpinTime", this.getDuration(stack, event.getEntityPlayer()));
            if (!event.getEntity().field_70170_p.field_72995_K) {
                int cooldown = this.isSword(stack.func_77973_b()) ? cooldownSword : cooldownAxe - EnchantmentHelper.func_77506_a((Enchantment)ench, (ItemStack)stack) * 12;
                for (Item item : GameRegistry.findRegistry(Item.class)) {
                    if (!this.isValid(item)) continue;
                    event.getEntityPlayer().func_184811_cZ().func_185145_a(item, cooldown);
                }
                if (!stack.func_77942_o()) {
                    stack.func_77982_d(new NBTTagCompound());
                }
                stack.func_77978_p().func_74757_a("SpinningS", true);
                event.getEntityPlayer().func_184212_Q().func_187227_b(SPIN_TIME, (Object)true);
            } else if (stack.func_77973_b() instanceof ItemSword || stack.func_77973_b() instanceof ItemTool) {
                boolean found = false;
                for (ResourceLocation location : swordItems) {
                    if (!location.equals((Object)stack.func_77973_b().getRegistryName())) continue;
                    found = true;
                    break;
                }
                for (ResourceLocation location : toolItems) {
                    if (!location.equals((Object)stack.func_77973_b().getRegistryName())) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    this.addToBlacklist(stack);
                    event.setCanceled(true);
                }
            }
        }
    }

    public int getDuration(ItemStack stack, EntityPlayer player) {
        return (int)(this.isSword(stack.func_77973_b()) ? (float)(duration + EnchantmentHelper.func_77506_a((Enchantment)ench, (ItemStack)stack) * 20) : (player.func_184818_cX() - 1.0f) * (1.0f - (float)EnchantmentHelper.func_77506_a((Enchantment)ench, (ItemStack)stack) * 0.1f) * 2.0f);
    }

    public int getSpinCooldown(ItemStack stack, EntityPlayer player) {
        return Math.max(1, (int)(player.func_184818_cX() * (1.0f - (float)EnchantmentHelper.func_77506_a((Enchantment)ench, (ItemStack)stack) * 0.1f) * speed));
    }

    @SubscribeEvent
    public void entityConstructing(EntityEvent.EntityConstructing event) {
        if (event.getEntity() instanceof EntityPlayer) {
            event.getEntity().func_184212_Q().func_187214_a(SPIN_TIME, (Object)false);
        }
    }

    @SubscribeEvent
    public void livingUpdate(final LivingEvent.LivingUpdateEvent event) {
        if (!event.getEntity().field_70170_p.field_72995_K && event.getEntity() instanceof EntityPlayer && ((Boolean)event.getEntity().func_184212_Q().func_187225_a(SPIN_TIME)).booleanValue()) {
            final EntityPlayer player = (EntityPlayer)event.getEntity();
            ItemStack stack = player.func_184614_ca();
            if (stack.func_190926_b() || !stack.func_77942_o() || !stack.func_77978_p().func_74767_n("SpinningS")) {
                for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                    ItemStack inSlot = player.field_71071_by.func_70301_a(i);
                    if (!inSlot.func_77942_o() || !inSlot.func_77978_p().func_74764_b("SpinningS")) continue;
                    inSlot.func_77978_p().func_74757_a("SpinningS", false);
                }
                event.getEntity().func_184212_Q().func_187227_b(SPIN_TIME, (Object)false);
            } else {
                int spin = player.getEntityData().func_74762_e("SpinTime");
                int cooldown = this.getSpinCooldown(stack, player);
                int enchantlevel = EnchantmentHelper.func_77506_a((Enchantment)ench, (ItemStack)stack);
                final double range = SpinToWin.range + 0.36 * (double)enchantlevel;
                NBTTagList list = player.getEntityData().func_150295_c("EntitiesDelayS", 3);
                if ((this.getDuration(stack, player) - spin) % cooldown == cooldown - 1) {
                    player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187730_dW, player.func_184176_by(), 1.0f, 1.0f);
                    if (player.getEntityData().func_74764_b("EntitiesDelayS")) {
                        player.getEntityData().func_74782_a("EntitiesDelayS", (NBTBase)new NBTTagList());
                    }
                    for (EntityLivingBase target : player.field_70170_p.func_175647_a(EntityLivingBase.class, player.func_174813_aQ().func_72314_b(range, 0.0, range), (Predicate)new Predicate<EntityLivingBase>(){

                        public boolean apply(EntityLivingBase input) {
                            return input != event.getEntity() && SpinToWin.isSuitableTarget(player, input, false, true) && input.func_70068_e((Entity)player) < (range + (double)(input.field_70130_N / 2.0f)) * (range + (double)(input.field_70130_N / 2.0f));
                        }
                    })) {
                        list.func_74742_a((NBTBase)new NBTTagInt(target.func_145782_y()));
                        if (list.func_74745_c() < cooldown) continue;
                        break;
                    }
                }
                if (list.func_74745_c() > 0) {
                    try {
                        AttributeModifier spinAD = new AttributeModifier(SPIN_AD, "SpinAD", this.isSword(stack.func_77973_b()) ? (double)(swordDmg - 1.0f) + (double)enchantlevel * 0.05 : (double)(axeDmg - 1.0f) + (double)enchantlevel * 0.1, 2);
                        player.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111121_a(spinAD);
                        AttributeModifier spinAS = new AttributeModifier(SPIN_AS, "SpinA", 1000.0, 2);
                        player.func_110148_a(SharedMonsterAttributes.field_188790_f).func_111121_a(spinAS);
                        Entity target = player.field_70170_p.func_73045_a(list.func_186858_c(0));
                        if (target != null && target.func_70089_S()) {
                            player.func_71059_n(target);
                            if (target instanceof EntityLivingBase && ((EntityLivingBase)target).field_70771_an >= cooldown * 2) {
                                ((EntityLivingBase)target).field_70172_ad = cooldown * 2 - 2;
                            }
                        }
                        list.func_74744_a(0);
                    }
                    catch (Exception e) {
                        throw e;
                    }
                    finally {
                        player.func_110148_a(SharedMonsterAttributes.field_188790_f).func_188479_b(SPIN_AS);
                        player.func_110148_a(SharedMonsterAttributes.field_111264_e).func_188479_b(SPIN_AD);
                    }
                }
                player.getEntityData().func_74782_a("EntitiesDelayS", (NBTBase)list);
                player.getEntityData().func_74768_a("SpinTime", spin - 1);
                if (spin == 1) {
                    player.func_184212_Q().func_187227_b(SPIN_TIME, (Object)false);
                }
                if (spin == 1 && stack.func_77942_o()) {
                    for (int i = 0; i < list.func_74745_c(); ++i) {
                        list.func_74744_a(list.func_74745_c() - 1);
                    }
                    stack.func_77978_p().func_74757_a("SpinningS", false);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void renderPlayer(RenderPlayerEvent.Pre event) {
        if (((Boolean)event.getEntity().func_184212_Q().func_187225_a(SPIN_TIME)).booleanValue()) {
            event.getRenderer().func_177087_b().field_187076_m = ModelBiped.ArmPose.BOW_AND_ARROW;
            GlStateManager.func_179094_E();
            ItemStack stack = event.getEntityPlayer().func_184614_ca();
            int spinCooldown = this.getSpinCooldown(stack, event.getEntityPlayer());
            if ((float)event.getEntityPlayer().getEntityData().func_74762_e("SpinTime") > (float)this.getDuration(stack, event.getEntityPlayer()) - (float)spinCooldown * 0.8f) {
                GlStateManager.func_179114_b((float)(((float)this.getDuration(stack, event.getEntityPlayer()) - ((float)event.getEntity().getEntityData().func_74762_e("SpinTime") - event.getPartialRenderTick())) * (float)(-(90 / this.getSpinCooldown(stack, event.getEntityPlayer())))), (float)0.0f, (float)1.0f, (float)0.0f);
            } else {
                GlStateManager.func_179114_b((float)(((float)this.getDuration(stack, event.getEntityPlayer()) - ((float)event.getEntity().getEntityData().func_74762_e("SpinTime") - event.getPartialRenderTick())) * (float)(360 / this.getSpinCooldown(stack, event.getEntityPlayer()))), (float)0.0f, (float)1.0f, (float)0.0f);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void renderLivingEntity(RenderLivingEvent.Pre<EntityPlayer> event) {
        if (event.getEntity() instanceof EntityPlayer && ((Boolean)event.getEntity().func_184212_Q().func_187225_a(SPIN_TIME)).booleanValue()) {
            ((ModelPlayer)event.getRenderer().func_177087_b()).field_187076_m = ModelBiped.ArmPose.BOW_AND_ARROW;
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void renderPlayer(RenderPlayerEvent.Post event) {
        ItemStack stack = event.getEntityPlayer().func_184614_ca();
        if (((Boolean)event.getEntity().func_184212_Q().func_187225_a(SPIN_TIME)).booleanValue()) {
            GlStateManager.func_179121_F();
            if (!stack.func_190926_b() && !event.getEntity().func_82150_aj()) {
                Tessellator tessellator = Tessellator.func_178181_a();
                VertexBuffer renderer = tessellator.func_178180_c();
                GlStateManager.func_179094_E();
                GlStateManager.func_179137_b((double)0.0, (double)0.1, (double)0.0);
                int cooldown = this.getSpinCooldown(stack, event.getEntityPlayer());
                double range = SpinToWin.range + (double)EnchantmentHelper.func_77506_a((Enchantment)ench, (ItemStack)stack) * 0.36 + 0.1;
                float alpha = 0.3f + (float)((this.getDuration(stack, event.getEntityPlayer()) - event.getEntityPlayer().getEntityData().func_74762_e("SpinTime")) % cooldown) / (float)cooldown * 0.5f;
                Minecraft.func_71410_x().func_110434_K().func_110577_a(SPIN_TEXTURE);
                GlStateManager.func_179140_f();
                GL11.glEnable((int)3042);
                OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
                if (this.isSword(stack.func_77973_b())) {
                    GlStateManager.func_179131_c((float)0.8f, (float)0.65f, (float)0.4f, (float)alpha);
                } else {
                    GlStateManager.func_179131_c((float)0.6f, (float)0.18f, (float)0.1f, (float)alpha);
                }
                renderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                renderer.func_181662_b(-range, 0.0, range).func_187315_a(0.0, 1.0).func_181675_d();
                renderer.func_181662_b(range, 0.0, range).func_187315_a(1.0, 1.0).func_181675_d();
                renderer.func_181662_b(range, 0.0, -range).func_187315_a(1.0, 0.0).func_181675_d();
                renderer.func_181662_b(-range, 0.0, -range).func_187315_a(0.0, 0.0).func_181675_d();
                tessellator.func_78381_a();
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glDisable((int)3042);
                GlStateManager.func_179145_e();
                GlStateManager.func_179121_F();
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void tickEvent(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            if (player != null && ((Boolean)player.func_184212_Q().func_187225_a(SPIN_TIME)).booleanValue() && !player.func_184614_ca().func_190926_b()) {
                player.getEntityData().func_74768_a("SpinTime", player.getEntityData().func_74762_e("SpinTime") - 1);
                if (player.getEntityData().func_74762_e("SpinTime") <= 0) {
                    player.getEntityData().func_74768_a("SpinTime", this.getDuration(player.func_184614_ca(), (EntityPlayer)player));
                }
                if (Minecraft.func_71410_x().field_71474_y.field_74320_O == 0) {
                    Minecraft.func_71410_x().field_71474_y.field_74320_O = 1;
                    player.getEntityData().func_74757_a("SetFirstpersonAfter", true);
                }
            }
            if (player != null && !((Boolean)player.func_184212_Q().func_187225_a(SPIN_TIME)).booleanValue() && player.getEntityData().func_74767_n("SetFirstpersonAfter")) {
                Minecraft.func_71410_x().field_71474_y.field_74320_O = 0;
                player.getEntityData().func_74757_a("SetFirstpersonAfter", false);
            }
        }
    }

    public static boolean isSuitableTarget(EntityPlayer attacker, @Nullable EntityLivingBase target, boolean includeInvincibles, boolean checkSight) {
        if (target == null) {
            return false;
        }
        if (target == attacker) {
            return false;
        }
        if (!target.func_70089_S()) {
            return false;
        }
        if (target instanceof EntityPlayer && !attacker.func_96122_a((EntityPlayer)target)) {
            return false;
        }
        if (attacker instanceof IEntityOwnable && ((IEntityOwnable)attacker).func_184753_b() != null) {
            if (target instanceof IEntityOwnable && ((IEntityOwnable)attacker).func_184753_b().equals(target.func_110124_au())) {
                return false;
            }
            if (target == ((IEntityOwnable)attacker).func_70902_q()) {
                return false;
            }
        } else if (target instanceof EntityPlayer && !includeInvincibles && ((EntityPlayer)target).field_71075_bZ.field_75102_a) {
            return false;
        }
        return !checkSight || attacker.func_70685_l((Entity)target);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent eventArgs) {
        if (eventArgs.getModID().equals("rafradek_spin")) {
            this.syncConfig();
        }
    }

    static {
        SPIN_AS = UUID.fromString("0706d45a-daae-429c-843c-23c03b721b32");
        SPIN_AD = UUID.fromString("b308e311-0557-405d-bb3e-551fd34edc25");
        SPIN_TEXTURE = new ResourceLocation("rafradek_spin", "textures/misc/spin.png");
    }
}

