/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.claysoldiers.client.util;

import de.sanandrew.mods.claysoldiers.api.soldier.Team;
import de.sanandrew.mods.claysoldiers.item.ItemDisruptor;
import de.sanandrew.mods.claysoldiers.registry.ItemRegistry;
import de.sanandrew.mods.claysoldiers.registry.TeamRegistry;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
@Mod.EventBusSubscriber(value={Side.CLIENT})
public final class ModelRegistry {
    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) throws Exception {
    }

    public static void registerModelsInit() {
        ModelRegistry.setCustomMeshModel(ItemRegistry.doll_soldier, new MeshDefUUID.Soldier());
        ModelRegistry.setCustomMeshModel(ItemRegistry.disruptor, new MeshDefDisruptor());
    }

    private static void setStandardModel(Item item) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName(), "inventory"));
    }

    private static void setStandardModel(Block item) {
        Item itm = Item.func_150898_a((Block)item);
        if (itm != null) {
            ModelRegistry.setStandardModel(itm);
        }
    }

    private static void setCustomMeshModel(Item item, MeshDef mesher) {
        Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178080_a(item, mesher.getMeshDef());
        ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])mesher.getResLocations());
    }

    private static abstract class MeshDefUUID<T>
    implements ItemMeshDefinition,
    MeshDef {
        public final Map<UUID, ModelResourceLocation> modelRes = new HashMap<UUID, ModelResourceLocation>();

        private MeshDefUUID() {
        }

        public ModelResourceLocation func_178113_a(ItemStack stack) {
            T type = this.getType(stack);
            return type != null ? this.modelRes.get(this.getId(type)) : new ModelResourceLocation(stack.func_77973_b().getRegistryName(), "inventory");
        }

        public abstract T getType(ItemStack var1);

        public abstract UUID getId(T var1);

        @Override
        public ResourceLocation[] getResLocations() {
            return (ResourceLocation[])this.modelRes.values().toArray(new ModelResourceLocation[this.modelRes.size()]);
        }

        public ItemMeshDefinition getMeshDef() {
            return this;
        }

        static final class Soldier
        extends MeshDefUUID<Team> {
            Soldier() {
                for (Team info : TeamRegistry.INSTANCE.getTeams()) {
                    ModelResourceLocation modelRes = new ModelResourceLocation(info.getItemModel(), "inventory");
                    this.modelRes.put(info.getId(), modelRes);
                }
            }

            @Override
            public Team getType(ItemStack stack) {
                return TeamRegistry.INSTANCE.getTeam(stack);
            }

            @Override
            public UUID getId(Team type) {
                return type.getId();
            }
        }
    }

    private static class MeshDefDisruptor
    implements ItemMeshDefinition,
    MeshDef {
        public final Map<ItemDisruptor.DisruptorType, ModelResourceLocation> modelRes = new HashMap<ItemDisruptor.DisruptorType, ModelResourceLocation>();

        public MeshDefDisruptor() {
            for (ItemDisruptor.DisruptorType type : ItemDisruptor.DisruptorType.VALUES) {
                if (type == ItemDisruptor.DisruptorType.UNKNOWN) continue;
                ModelResourceLocation modelRes = new ModelResourceLocation(new ResourceLocation("claysoldiers", "disruptors/" + type.name), "inventory");
                this.modelRes.put(type, modelRes);
            }
        }

        public ModelResourceLocation func_178113_a(ItemStack stack) {
            ItemDisruptor.DisruptorType type = ItemDisruptor.getType(stack);
            return this.modelRes.get((Object)type);
        }

        @Override
        public ResourceLocation[] getResLocations() {
            return (ResourceLocation[])this.modelRes.values().toArray(new ModelResourceLocation[this.modelRes.size()]);
        }

        public ItemMeshDefinition getMeshDef() {
            return this;
        }
    }

    private static interface MeshDef<T extends ItemMeshDefinition> {
        public ResourceLocation[] getResLocations();

        public T getMeshDef();
    }
}

