/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.claysoldiers.item;

import de.sanandrew.mods.claysoldiers.api.soldier.Team;
import de.sanandrew.mods.claysoldiers.entity.EntityClaySoldier;
import de.sanandrew.mods.claysoldiers.registry.TeamRegistry;
import de.sanandrew.mods.claysoldiers.util.CsmCreativeTabs;
import de.sanandrew.mods.sanlib.lib.util.MiscUtils;
import de.sanandrew.mods.sanlib.lib.util.UuidUtils;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.BlockCauldron;
import net.minecraft.block.BlockFence;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class ItemSoldier
extends Item {
    private static final IItemPropertyGetter SOLDIER_TEX_ID = (stack, worldIn, entityIn) -> TeamRegistry.INSTANCE.getTeams().indexOf(TeamRegistry.INSTANCE.getTeam(stack));

    public ItemSoldier() {
        this.func_77637_a(CsmCreativeTabs.DOLLS);
        this.func_77655_b("claysoldiers:doll_soldier");
        this.func_185043_a(new ResourceLocation("soldierTeamId"), SOLDIER_TEX_ID);
        this.func_77656_e(0);
        this.func_77627_a(true);
        this.field_77777_bU = 16;
    }

    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        list.addAll(TeamRegistry.INSTANCE.getTeams().stream().map(team -> TeamRegistry.INSTANCE.setTeam(new ItemStack((Item)this, 1), (Team)team)).collect(Collectors.toList()));
    }

    public String func_77667_c(ItemStack stack) {
        return super.func_77667_c(stack) + '.' + TeamRegistry.INSTANCE.getTeam(stack).getName();
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        EntityClaySoldier[] soldiers;
        if (world.field_72995_K) {
            return EnumActionResult.SUCCESS;
        }
        if (!player.func_175151_a(pos.func_177972_a(facing), facing, stack)) {
            return EnumActionResult.FAIL;
        }
        if (world.func_180495_p(pos).func_177230_c() == Blocks.field_150383_bp && hand != null) {
            IBlockState state;
            int level;
            if (!player.func_70093_af() && !UuidUtils.areUuidsEqual((Object)TeamRegistry.INSTANCE.getTeam(stack).getId(), (Object)TeamRegistry.SOLDIER_CLAY) && (level = ((Integer)(state = world.func_180495_p(pos)).func_177229_b((IProperty)BlockCauldron.field_176591_a)).intValue()) > 0) {
                player.func_184611_a(hand, TeamRegistry.INSTANCE.setTeam(stack.func_77946_l(), TeamRegistry.SOLDIER_CLAY));
                player.field_71069_bz.func_75142_b();
                player.func_71029_a(StatList.field_188078_L);
                Blocks.field_150383_bp.func_176590_a(world, pos, state, level - 1);
                return EnumActionResult.SUCCESS;
            }
            return EnumActionResult.FAIL;
        }
        IBlockState iblockstate = world.func_180495_p(pos);
        pos = pos.func_177972_a(facing);
        double yShift = 0.0;
        if (facing == EnumFacing.UP && iblockstate.func_177230_c() instanceof BlockFence) {
            yShift = 0.5;
        }
        for (EntityClaySoldier james : soldiers = ItemSoldier.spawnSoldiers(world, TeamRegistry.INSTANCE.getTeam(stack), player.func_70093_af() ? 1 : stack.field_77994_a, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + yShift, (double)pos.func_177952_p() + 0.4 + (double)MiscUtils.RNG.randomFloat() * 0.2, stack)) {
            if (james == null) continue;
            if (stack.func_82837_s()) {
                james.func_96094_a(stack.func_82833_r());
            }
            --stack.field_77994_a;
        }
        if (hand != null && player.field_71075_bZ.field_75098_d) {
            if (stack.field_77994_a < 1) {
                player.func_184611_a(hand, null);
            } else {
                player.func_184611_a(hand, stack.func_77946_l());
            }
            player.field_71069_bz.func_75142_b();
        }
        return EnumActionResult.SUCCESS;
    }

    public static EntityClaySoldier[] spawnSoldiers(World world, Team team, int count, double x, double y, double z, ItemStack dollStack) {
        if (team != TeamRegistry.NULL_TEAM) {
            EntityClaySoldier[] soldiers = new EntityClaySoldier[count];
            for (int i = 0; i < count; ++i) {
                double xs = x - 0.1 + (double)MiscUtils.RNG.randomFloat() * 0.02;
                double zs = z - 0.1 + (double)MiscUtils.RNG.randomFloat() * 0.02;
                ItemStack newDollStack = null;
                if (dollStack != null) {
                    newDollStack = dollStack.func_77946_l();
                    newDollStack.field_77994_a = 1;
                }
                EntityClaySoldier aleks = new EntityClaySoldier(world, team, newDollStack);
                aleks.func_70012_b(xs, y, zs, MathHelper.func_76142_g((float)(world.field_73012_v.nextFloat() * 360.0f)), 0.0f);
                aleks.field_70759_as = aleks.field_70177_z;
                aleks.field_70761_aq = aleks.field_70177_z;
                aleks.func_180482_a(world.func_175649_E(new BlockPos((Entity)aleks)), null);
                world.func_72838_d((Entity)aleks);
                aleks.func_70642_aH();
                soldiers[i] = aleks;
            }
            return soldiers;
        }
        return new EntityClaySoldier[0];
    }
}

