/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.claysoldiers.util;

import de.sanandrew.mods.claysoldiers.api.CsmConstants;
import de.sanandrew.mods.claysoldiers.api.CsmPlugin;
import de.sanandrew.mods.claysoldiers.api.ICsmPlugin;
import de.sanandrew.mods.claysoldiers.crafting.CraftingRecipes;
import de.sanandrew.mods.claysoldiers.registry.TeamRegistry;
import de.sanandrew.mods.claysoldiers.util.CommonProxy;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;

@Mod(modid="claysoldiers", version="3.0.0-alpha.1", name="Clay Soldiers Mod", dependencies="required-after:Forge@[12.18.2.2099,];required-after:sanlib@[1.0.0,]", acceptedMinecraftVersions="[1.10.2]")
public class ClaySoldiersMod {
    public static SimpleNetworkWrapper network;
    private static final String MOD_PROXY_CLIENT = "de.sanandrew.mods.claysoldiers.client.util.ClientProxy";
    private static final String MOD_PROXY_COMMON = "de.sanandrew.mods.claysoldiers.util.CommonProxy";
    private static final List<ICsmPlugin> PLUGINS;
    @Mod.Instance(value="claysoldiers")
    public static ClaySoldiersMod instance;
    @SidedProxy(modId="claysoldiers", clientSide="de.sanandrew.mods.claysoldiers.client.util.ClientProxy", serverSide="de.sanandrew.mods.claysoldiers.util.CommonProxy")
    public static CommonProxy proxy;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        event.getModMetadata().autogenerated = false;
        ClaySoldiersMod.loadPlugins(event.getAsmData());
        network = NetworkRegistry.INSTANCE.newSimpleChannel("ClaySoldiersNWCH");
        PLUGINS.forEach(plugin -> plugin.registerTeams(TeamRegistry.INSTANCE));
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)proxy);
        proxy.preInit(event);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.init(event);
        CraftingRecipes.initialize();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        proxy.postInit(event);
    }

    private static void loadPlugins(ASMDataTable dataTable) {
        String annotationClassName = CsmPlugin.class.getCanonicalName();
        Set asmDatas = dataTable.getAll(annotationClassName);
        for (ASMDataTable.ASMData asmData : asmDatas) {
            try {
                Class<?> asmClass = Class.forName(asmData.getClassName());
                Class<ICsmPlugin> asmInstanceClass = asmClass.asSubclass(ICsmPlugin.class);
                ICsmPlugin instance = asmInstanceClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                PLUGINS.add(instance);
            }
            catch (ClassNotFoundException | ExceptionInInitializerError | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                CsmConstants.LOG.error("Failed to load: {}", new Object[]{asmData.getClassName(), e});
            }
        }
    }

    static {
        PLUGINS = new ArrayList<ICsmPlugin>();
    }
}

