/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.claysoldiers.compat.jei;

import de.sanandrew.mods.claysoldiers.api.soldier.Team;
import de.sanandrew.mods.claysoldiers.compat.jei.DyedSoldierRecipeWrapper;
import de.sanandrew.mods.claysoldiers.crafting.DyedSoldierRecipe;
import de.sanandrew.mods.claysoldiers.registry.TeamRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import mezz.jei.api.recipe.IRecipeHandler;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class DyedSoldierRecipeHandler
implements IRecipeHandler<JeiDyedSoldierRecipe> {
    public Class<JeiDyedSoldierRecipe> getRecipeClass() {
        return JeiDyedSoldierRecipe.class;
    }

    public String getRecipeCategoryUid() {
        return "minecraft.crafting";
    }

    public String getRecipeCategoryUid(JeiDyedSoldierRecipe recipe) {
        return "minecraft.crafting";
    }

    public IRecipeWrapper getRecipeWrapper(JeiDyedSoldierRecipe recipe) {
        return new DyedSoldierRecipeWrapper(recipe);
    }

    public boolean isRecipeValid(JeiDyedSoldierRecipe recipe) {
        return true;
    }

    static List<JeiDyedSoldierRecipe> getRecipes() {
        ArrayList<JeiDyedSoldierRecipe> recipes = new ArrayList<JeiDyedSoldierRecipe>();
        for (int i = 0; i < DyedSoldierRecipe.TEAMS.length; ++i) {
            String dye = DyedSoldierRecipe.DYES[i];
            UUID team = DyedSoldierRecipe.TEAMS[i];
            for (int j = 1; j <= 8; ++j) {
                recipes.add(new JeiDyedSoldierRecipe(dye, team, j));
            }
        }
        return recipes;
    }

    static class JeiDyedSoldierRecipe {
        final ItemStack result;
        final List<List<ItemStack>> ingredients;

        JeiDyedSoldierRecipe(String dyeColor, UUID team, int count) {
            this.result = TeamRegistry.INSTANCE.getNewTeamStack(count, team);
            this.ingredients = new ArrayList<List<ItemStack>>();
            this.ingredients.add(OreDictionary.getOres((String)dyeColor));
            ArrayList<Team> teamList = TeamRegistry.INSTANCE.getTeams();
            for (int i = 0; i < count; ++i) {
                ArrayList<ItemStack> ingredList = new ArrayList<ItemStack>();
                for (Team teamInst : teamList) {
                    ingredList.add(TeamRegistry.INSTANCE.getNewTeamStack(1, teamInst.getId()));
                }
                this.ingredients.add(ingredList);
            }
        }
    }
}

