/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.claysoldiers.item;

import de.sanandrew.mods.claysoldiers.api.Disruptable;
import de.sanandrew.mods.claysoldiers.registry.ItemRegistry;
import de.sanandrew.mods.claysoldiers.util.CsmCreativeTabs;
import de.sanandrew.mods.sanlib.lib.util.ItemStackUtils;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;

public class ItemDisruptor
extends Item {
    private static final IItemPropertyGetter DISRUPTOR_TEX = (stack, worldIn, entityIn) -> ItemDisruptor.getType(stack).ordinal();
    public static final DamageSource DISRUPT_DAMAGE = new DamageSource("claysoldiers.disrupt").func_151518_m();

    public ItemDisruptor() {
        this.func_77637_a(CsmCreativeTabs.DOLLS);
        this.func_77655_b("claysoldiers:disruptor");
        this.func_185043_a(new ResourceLocation("disruptorType"), DISRUPTOR_TEX);
        this.func_77627_a(true);
        this.field_77777_bU = 1;
    }

    public int getMaxDamage(ItemStack stack) {
        return ItemDisruptor.getType((ItemStack)stack).damage;
    }

    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        list.addAll(Arrays.stream(DisruptorType.VALUES).filter(type -> !type.name.equals("null")).map(type -> ItemDisruptor.setType(new ItemStack((Item)this, 1), type)).collect(Collectors.toList()));
    }

    public String func_77667_c(ItemStack stack) {
        return super.func_77667_c(stack) + '.' + ItemDisruptor.getType((ItemStack)stack).name;
    }

    public int func_77626_a(ItemStack stack) {
        return 0;
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn, EnumHand hand) {
        long currTimeMillis;
        NBTTagCompound nbt = itemStackIn.func_179543_a("disruptor", true);
        long lastTimeMillis = nbt.func_74763_f("lastActivated");
        if (lastTimeMillis + 2000L < (currTimeMillis = System.currentTimeMillis())) {
            if (!worldIn.field_72995_K) {
                AxisAlignedBB aabb = new AxisAlignedBB(0.0, 0.0, 0.0, 64.0, 64.0, 64.0).func_72317_d(playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v).func_72317_d(-32.0, -32.0, -32.0);
                worldIn.func_72872_a(EntityCreature.class, aabb).stream().filter(entity -> entity instanceof Disruptable).map(entity -> (Disruptable)entity).collect(Collectors.toList()).forEach(Disruptable::disrupt);
                nbt.func_74772_a("lastActivated", currTimeMillis);
                if (itemStackIn.func_77984_f()) {
                    itemStackIn.func_77972_a(1, (EntityLivingBase)playerIn);
                }
            }
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)itemStackIn);
        }
        return super.func_77659_a(itemStackIn, worldIn, playerIn, hand);
    }

    public static DisruptorType getType(ItemStack stack) {
        NBTTagCompound nbt;
        if (ItemStackUtils.isItem((ItemStack)stack, (Item)ItemRegistry.disruptor) && (nbt = stack.func_179543_a("disruptor", false)) != null && nbt.func_150297_b("type", 1)) {
            byte type = nbt.func_74771_c("type");
            return type >= 0 && type < DisruptorType.VALUES.length ? DisruptorType.VALUES[type] : DisruptorType.UNKNOWN;
        }
        return DisruptorType.UNKNOWN;
    }

    public static ItemStack setType(ItemStack stack, DisruptorType type) {
        if (ItemStackUtils.isItem((ItemStack)stack, (Item)ItemRegistry.disruptor)) {
            NBTTagCompound nbt = stack.func_179543_a("disruptor", true);
            nbt.func_74774_a("type", (byte)type.ordinal());
        }
        return stack;
    }

    public static enum DisruptorType {
        CLAY("clay", 32),
        HARDENED("hardened", 128),
        OBSIDIAN("unbreaking", 0),
        UNKNOWN("null", 1);

        public final String name;
        public final int damage;
        public static final DisruptorType[] VALUES;

        private DisruptorType(String name, int damage) {
            this.name = name;
            this.damage = damage;
        }

        static {
            VALUES = DisruptorType.values();
        }
    }
}

