/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.claysoldiers.crafting;

import de.sanandrew.mods.claysoldiers.item.ItemDisruptor;
import de.sanandrew.mods.claysoldiers.registry.ItemRegistry;
import de.sanandrew.mods.sanlib.lib.util.ItemStackUtils;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.oredict.OreDictionary;

class DisruptorRecipe
implements IRecipe {
    private final ItemStack result;
    private ItemStack[] coreItems;

    public DisruptorRecipe(ItemDisruptor.DisruptorType type) {
        this.result = ItemDisruptor.setType(new ItemStack((Item)ItemRegistry.disruptor, 1), type);
        switch (type) {
            case CLAY: {
                this.coreItems = new ItemStack[]{new ItemStack(Blocks.field_150435_aG, 1)};
                break;
            }
            case HARDENED: {
                this.coreItems = new ItemStack[17];
                this.coreItems[16] = new ItemStack(Blocks.field_150405_ch, 1);
                for (int i = 0; i < 16; ++i) {
                    this.coreItems[i] = new ItemStack(Blocks.field_150406_ce, 1, i);
                }
                break;
            }
            case OBSIDIAN: {
                this.coreItems = (ItemStack[])OreDictionary.getOres((String)"obsidian").stream().toArray(ItemStack[]::new);
            }
        }
    }

    public boolean func_77569_a(InventoryCrafting inv, World worldIn) {
        if (this.coreItems == null || this.coreItems.length < 1) {
            return false;
        }
        if (ItemStackUtils.isValid((ItemStack)inv.func_70301_a(0)) || ItemStackUtils.isValid((ItemStack)inv.func_70301_a(2))) {
            return false;
        }
        if (!OreDictionary.containsMatch((boolean)false, (List)OreDictionary.getOres((String)"stickWood"), (ItemStack[])new ItemStack[]{inv.func_70301_a(1)})) {
            return false;
        }
        if (!OreDictionary.containsMatch((boolean)false, (List)OreDictionary.getOres((String)"dustRedstone"), (ItemStack[])new ItemStack[]{inv.func_70301_a(7)})) {
            return false;
        }
        if (!(ItemStackUtils.isItem((ItemStack)inv.func_70301_a(3), (Item)Items.field_151119_aD) && ItemStackUtils.isItem((ItemStack)inv.func_70301_a(5), (Item)Items.field_151119_aD) && ItemStackUtils.isItem((ItemStack)inv.func_70301_a(6), (Item)Items.field_151119_aD) && ItemStackUtils.isItem((ItemStack)inv.func_70301_a(8), (Item)Items.field_151119_aD))) {
            return false;
        }
        return OreDictionary.containsMatch((boolean)false, Arrays.asList(this.coreItems), (ItemStack[])new ItemStack[]{inv.func_70301_a(4)});
    }

    @Nullable
    public ItemStack func_77572_b(InventoryCrafting inv) {
        return this.result.func_77946_l();
    }

    public int func_77570_a() {
        return 8;
    }

    @Nullable
    public ItemStack func_77571_b() {
        return this.result;
    }

    public ItemStack[] func_179532_b(InventoryCrafting inv) {
        ItemStack[] invStacks = new ItemStack[inv.func_70302_i_()];
        for (int i = 0; i < invStacks.length; ++i) {
            ItemStack itemstack = inv.func_70301_a(i);
            invStacks[i] = ForgeHooks.getContainerItem((ItemStack)itemstack);
        }
        return invStacks;
    }
}

