/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.claysoldiers.entity;

import de.sanandrew.mods.claysoldiers.api.Disruptable;
import de.sanandrew.mods.claysoldiers.api.soldier.Team;
import de.sanandrew.mods.claysoldiers.entity.ai.EntityAISoldierAttackMelee;
import de.sanandrew.mods.claysoldiers.entity.ai.EntityAISoldierAttackableTarget;
import de.sanandrew.mods.claysoldiers.item.ItemDisruptor;
import de.sanandrew.mods.claysoldiers.network.datasync.DataSerializerUUID;
import de.sanandrew.mods.claysoldiers.network.datasync.DataWatcherBooleans;
import de.sanandrew.mods.claysoldiers.registry.TeamRegistry;
import de.sanandrew.mods.claysoldiers.util.RayTraceFixed;
import de.sanandrew.mods.sanlib.lib.util.ItemStackUtils;
import de.sanandrew.mods.sanlib.lib.util.MiscUtils;
import de.sanandrew.mods.sanlib.lib.util.UuidUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityClaySoldier
extends EntityCreature
implements Disruptable {
    private static final DataParameter<UUID> TEAM_PARAM = EntityDataManager.func_187226_a(EntityClaySoldier.class, (DataSerializer)DataSerializerUUID.INSTANCE);
    private static final DataParameter<Byte> TEXTURE_TYPE_PARAM = EntityDataManager.func_187226_a(EntityClaySoldier.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Byte> TEXTURE_ID_PARAM = EntityDataManager.func_187226_a(EntityClaySoldier.class, (DataSerializer)DataSerializers.field_187191_a);
    private final DataWatcherBooleans<EntityClaySoldier> dwBooleans;
    private ItemStack doll;

    public EntityClaySoldier(World world) {
        super(world);
        this.field_70138_W = 0.1f;
        this.field_70158_ak = true;
        this.field_70747_aH = 0.2f;
        this.func_70105_a(0.17f, 0.4f);
        this.field_70180_af.func_187214_a(TEAM_PARAM, (Object)TeamRegistry.NULL_TEAM.getId());
        this.field_70180_af.func_187214_a(TEXTURE_TYPE_PARAM, (Object)0);
        this.field_70180_af.func_187214_a(TEXTURE_ID_PARAM, (Object)0);
        this.dwBooleans = new DataWatcherBooleans<EntityClaySoldier>(this);
        this.dwBooleans.registerDwValue();
        this.setMovable(true);
        ((PathNavigateGround)this.func_70661_as()).func_179693_d(true);
    }

    public EntityClaySoldier(World world, @Nonnull Team team, @Nullable ItemStack doll) {
        this(world, team);
        this.doll = doll;
    }

    public EntityClaySoldier(World world, @Nonnull Team team) {
        this(world);
        this.field_70180_af.func_187227_b(TEAM_PARAM, (Object)team.getId());
        if (MiscUtils.RNG.randomInt(1000000) == 0) {
            int[] texIds = team.getUniqueTextureIds();
            if (texIds.length > 0) {
                this.field_70180_af.func_187227_b(TEXTURE_TYPE_PARAM, (Object)2);
                this.field_70180_af.func_187227_b(TEXTURE_ID_PARAM, (Object)((byte)texIds[MiscUtils.RNG.randomInt(texIds.length)]));
            }
        } else if (MiscUtils.RNG.randomInt(250) == 0) {
            int[] texIds = team.getRareTextureIds();
            if (texIds.length > 0) {
                this.field_70180_af.func_187227_b(TEXTURE_TYPE_PARAM, (Object)1);
                this.field_70180_af.func_187227_b(TEXTURE_ID_PARAM, (Object)((byte)texIds[MiscUtils.RNG.randomInt(texIds.length)]));
            }
        } else {
            int[] texIds = team.getNormalTextureIds();
            this.field_70180_af.func_187227_b(TEXTURE_TYPE_PARAM, (Object)0);
            this.field_70180_af.func_187227_b(TEXTURE_ID_PARAM, (Object)((byte)texIds[MiscUtils.RNG.randomInt(texIds.length)]));
        }
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISoldierAttackMelee(this, 0.8));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 0.5));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.5));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAISoldierAttackableTarget(this));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.23f);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(32.0);
    }

    public boolean canMove() {
        return this.dwBooleans.getBit(DataWatcherBooleans.Soldier.CAN_MOVE.bit);
    }

    public void setMovable(boolean move) {
        this.dwBooleans.setBit(DataWatcherBooleans.Soldier.CAN_MOVE.bit, move);
    }

    public void setBreathableUnderwater(boolean breathable) {
        this.dwBooleans.setBit(DataWatcherBooleans.Soldier.BREATHE_WATER.bit, breathable);
    }

    public Team getSoldierTeam() {
        return TeamRegistry.INSTANCE.getTeam((UUID)this.field_70180_af.func_187225_a(TEAM_PARAM));
    }

    public int getTextureType() {
        return ((Byte)this.field_70180_af.func_187225_a(TEXTURE_TYPE_PARAM)).byteValue();
    }

    public int getTextureId() {
        return ((Byte)this.field_70180_af.func_187225_a(TEXTURE_ID_PARAM)).byteValue();
    }

    public void func_70091_d(double motionX, double motionY, double motionZ) {
        if (this.canMove()) {
            super.func_70091_d(motionX, motionY, motionZ);
        } else {
            super.func_70091_d(0.0, motionY > 0.0 ? motionY / 2.0 : motionY, 0.0);
        }
    }

    public boolean func_70652_k(Entity entityIn) {
        if (!(entityIn instanceof EntityLivingBase)) {
            return false;
        }
        EntityLivingBase trevor = (EntityLivingBase)entityIn;
        float attackDmg = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        int i = 0;
        i += EnchantmentHelper.func_77501_a((EntityLivingBase)this);
        boolean attackSuccess = trevor.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), attackDmg += EnchantmentHelper.func_152377_a((ItemStack)this.func_184614_ca(), (EnumCreatureAttribute)trevor.func_70668_bt()));
        if (attackSuccess) {
            int fireAspectMod;
            if (i > 0) {
                trevor.func_70653_a((Entity)this, (float)i * 0.5f, (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
                this.field_70159_w *= 0.6;
                this.field_70179_y *= 0.6;
            }
            if ((fireAspectMod = EnchantmentHelper.func_90036_a((EntityLivingBase)this)) > 0) {
                trevor.func_70015_d(fireAspectMod * 4);
            }
            this.func_174815_a((EntityLivingBase)this, (Entity)trevor);
            float additDifficulty = this.field_70170_p.func_175649_E(new BlockPos((Entity)this)).func_180168_b();
            if (this.func_184614_ca() == null && this.func_70027_ad() && this.field_70146_Z.nextFloat() < additDifficulty * 0.3f) {
                trevor.func_70015_d(2 * (int)additDifficulty);
            }
        }
        return attackSuccess;
    }

    protected float func_189749_co() {
        return 1.0f;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.canMove()) {
            this.field_70159_w = 0.0;
            this.field_70179_y = 0.0;
            this.field_70703_bu = false;
        }
    }

    public boolean func_70648_aU() {
        return this.dwBooleans.getBit(DataWatcherBooleans.Soldier.BREATHE_WATER.bit);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74778_a("soldier_team", ((UUID)this.field_70180_af.func_187225_a(TEAM_PARAM)).toString());
        compound.func_74774_a("soldier_texture_type", ((Byte)this.field_70180_af.func_187225_a(TEXTURE_TYPE_PARAM)).byteValue());
        compound.func_74774_a("soldier_texture_id", ((Byte)this.field_70180_af.func_187225_a(TEXTURE_ID_PARAM)).byteValue());
        if (this.doll != null) {
            ItemStackUtils.writeStackToTag((ItemStack)this.doll, (NBTTagCompound)compound, (String)"soldier_doll");
        }
        this.dwBooleans.writeToNbt(compound);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        String teamId = compound.func_74779_i("soldier_team");
        this.field_70180_af.func_187227_b(TEAM_PARAM, (Object)(UuidUtils.isStringUuid((String)teamId) ? UUID.fromString(teamId) : UuidUtils.EMPTY_UUID));
        this.field_70180_af.func_187227_b(TEXTURE_TYPE_PARAM, (Object)compound.func_74771_c("soldier_texture_type"));
        this.field_70180_af.func_187227_b(TEXTURE_ID_PARAM, (Object)compound.func_74771_c("soldier_texture_id"));
        if (compound.func_150297_b("soldier_doll", 10)) {
            this.doll = ItemStack.func_77949_a((NBTTagCompound)compound.func_74775_l("soldier_doll"));
        }
        this.dwBooleans.readFromNbt(compound);
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        if (!(source.func_76346_g() instanceof EntityPlayer) && source != ItemDisruptor.DISRUPT_DAMAGE) {
            if (this.func_184187_bx() != null && MiscUtils.RNG.randomInt(4) == 0) {
                this.func_184187_bx().func_70097_a(source, damage);
                return false;
            }
        } else {
            damage = Float.MAX_VALUE;
        }
        return super.func_70097_a(source, damage);
    }

    public void func_70645_a(DamageSource damageSource) {
        super.func_70645_a(damageSource);
        if (!this.field_70170_p.field_72995_K) {
            ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
            if (this.doll != null) {
                drops.add(this.doll);
            }
            drops.removeAll(Collections.singleton(null));
            for (ItemStack drop : drops) {
                this.func_70099_a(drop, 0.0f);
            }
        }
    }

    public void func_70653_a(Entity par1Entity, float par2, double par3, double par5) {
        if (!this.canMove()) {
            return;
        }
        super.func_70653_a(par1Entity, par2, par3, par5);
    }

    public boolean func_70685_l(Entity target) {
        RayTraceResult res = RayTraceFixed.rayTraceSight((Entity)this, this.field_70170_p, new Vec3d(this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v), new Vec3d(target.field_70165_t, target.field_70163_u + (double)target.func_70047_e(), target.field_70161_v));
        return res == null;
    }

    public boolean func_70104_M() {
        return this.canMove();
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return null;
    }

    protected SoundEvent func_184601_bQ() {
        return SoundEvents.field_187581_bW;
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187668_ca;
    }

    protected void func_70609_aI() {
        this.field_70725_aQ = 20;
        this.func_70106_y();
    }

    protected boolean func_70692_ba() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double distance) {
        double bbEdgeLength = this.func_174813_aQ().func_72320_b();
        if (Double.isNaN(bbEdgeLength)) {
            bbEdgeLength = 1.0;
        }
        return distance < (bbEdgeLength *= 320.0) * bbEdgeLength;
    }

    public double func_70033_W() {
        return 0.01f;
    }

    @Override
    public void disrupt() {
        this.func_70097_a(ItemDisruptor.DISRUPT_DAMAGE, Float.MAX_VALUE);
    }

    @Override
    public Disruptable.DisruptType getDisruptType() {
        return Disruptable.DisruptType.SOLDIER;
    }
}

